//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL GetRestoreName(char *FileName, HWND xDialog_hWnd)
{
    HSTMT fstmt;

    if(OpenDB(MasterDriver, MasterServer, MasterUID, MasterPWS, MasterTrusted, MasterDatabase) == FALSE)
    {
        char SQLErrorMsg[2048];
        GetSQLErrorMessage(SQLErrorMsg);
        ErrorMessage(xDialog_hWnd, SQLErrorMsg);
        return FALSE;
    }


    char StatementText[1024];
    int Result = 0;

    sprintf(StatementText, "RESTORE HEADERONLY FROM DISK = '%s'", FileName);
    Result = DBexecute(StatementText, &fstmt);

    SQLINTEGER dataID;

    Result = SQLFetch(fstmt);
    if(Result != SQL_SUCCESS && Result != SQL_SUCCESS_WITH_INFO)
    {
        ErrorMessage(JID.Dialog_hWnd, "Failed to retreive backup information from the file you selected.");
        return FALSE;
    }
    Result = SQLGetData(fstmt, 10, SQL_C_CHAR, SQLProcess.RestoreDBName, 100, &dataID);

    Set_Text(MRD.DataBase_hWnd, SQLProcess.RestoreDBName);

    DBclose();

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL GetRestoreStatement(char *FileName)
{
    HSTMT fstmt;

    if(OpenDB(MasterDriver, MasterServer, MasterUID, MasterPWS, MasterTrusted, MasterDatabase) == FALSE)
    {
        ErrorMessage(JID.Dialog_hWnd, "Failed to connect to local master database");
        return FALSE;
    }

    char StatementText[1024];
    int Result = 0;

    sprintf(StatementText, "RESTORE FILELISTONLY FROM DISK = '%s'", FileName);
    Result = DBexecute(StatementText, &fstmt);

    char DataName1[1024];
    char FileName1[1024];

    char DataName2[1024];
    char FileName2[1024];

    SQLINTEGER dataID;

    Result = SQLFetch(fstmt);
    if(Result != SQL_SUCCESS && Result != SQL_SUCCESS_WITH_INFO)
    {
        ErrorMessage(JID.Dialog_hWnd, "Failed to retreive backup information from the file you selected.");
        return FALSE;
    }
    Result = SQLGetData(fstmt, 1, SQL_C_CHAR, DataName1, 100, &dataID);
    Result = SQLGetData(fstmt, 2, SQL_C_CHAR, FileName1, 100, &dataID);

    Result = SQLFetch(fstmt);
    if(Result != SQL_SUCCESS && Result != SQL_SUCCESS_WITH_INFO)
    {
        ErrorMessage(JID.Dialog_hWnd, "Failed to retreive backup information from the file you selected.");
        return FALSE;
    }
    Result = SQLGetData(fstmt, 1, SQL_C_CHAR, DataName2, 100, &dataID);
    Result = SQLGetData(fstmt, 2, SQL_C_CHAR, FileName2, 100, &dataID);

    if(RWMD.Complete == TRUE)
    {
        sprintf(FileName1, "%s\\%s.mdf", RWMD.NewDBLoc, RWMD.NewDBName);
        sprintf(FileName2, "%s\\%s.ldf", RWMD.NewDBLoc, RWMD.NewDBName);
    }

    sprintf(SQLProcess.RestoreStatement, "WITH MOVE '%s' TO '%s', MOVE '%s' TO '%s'", DataName1, FileName1, DataName2, FileName2);

    DBclose();

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL GetRestoreLocation(char *FileName, char *ReturnLoc)
{
    HSTMT fstmt;

    if(OpenDB(MasterDriver, MasterServer, MasterUID, MasterPWS, MasterTrusted, MasterDatabase) == FALSE)
    {
        ErrorMessage(JID.Dialog_hWnd, "Failed to connect to local master database");
        return FALSE;
    }

    char StatementText[1024];
    int Result = 0;

    sprintf(StatementText, "RESTORE FILELISTONLY FROM DISK = '%s'", FileName);
    Result = DBexecute(StatementText, &fstmt);

    char FileName1[1024];

    SQLINTEGER dataID;

    Result = SQLFetch(fstmt);
    if(Result != SQL_SUCCESS && Result != SQL_SUCCESS_WITH_INFO)
    {
        ErrorMessage(JID.Dialog_hWnd, "Failed to retreive backup information from the file you selected.");
        return FALSE;
    }
    Result = SQLGetData(fstmt, 2, SQL_C_CHAR, FileName1, 100, &dataID);

    char drive[256];
    char dir[256];
    char file[256];
    char ext[256];

    _splitpath(FileName1, drive, dir, file, ext);
    _makepath(ReturnLoc, drive, dir, NULL, NULL);

    DBclose();

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

